<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Page extends Model 
{

    protected $table = 'pages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_ar', 'name_en', 'description_ar', 'description_en', 'is_active', 'type', 'model_type');

    public function files()
    {
        return $this->morphMany('File', 'model');
    }

}